package org.pgusb.usb4allLib;

import org.pgusb.usb4allAPIWrapper.ReadBytes;
import org.pgusb.usb4allAPIWrapper.Usb4allAPIWrapper;
import org.xvolks.jnative.exceptions.NativeException;

import exceptions.Usb4allAlreadyInitializedException;
import exceptions.Usb4allAlreadyReleasedException;
import exceptions.Usb4allBoardAlreadyAssignedException;
import exceptions.Usb4allCloseException;
import exceptions.Usb4allDeviceNotInitializedException;
import exceptions.Usb4allDllException;
import exceptions.Usb4allException;
import exceptions.Usb4allInitException;
import exceptions.Usb4allOpenError;
import exceptions.Usb4allReleaseException;

public abstract class Usb4allDevice {
	
	
	private int handler;
	private Usb4allBoard board=null;
	protected String moduleName;
	//tipos de endpoints a utlizar
	private int usbin;
	private int usbout;
	//estado del device
	//ESTADOS del device
	protected final static int BOARD_UNASSIGNED = 0;
	protected final static int BOARD_ASSIGNED = 1;
	protected final static int INITIALIZED = 2;
	protected final static int RELEASED=3;
	
	public static final int NULL_IN=Usb4allAPIWrapper.NULL_IN;
	public static final int BULK_IN=Usb4allAPIWrapper.BULK_IN;
	public static final int CTRL_IN=Usb4allAPIWrapper.CTRL_IN;
	public static final int INT_IN=Usb4allAPIWrapper.INT_IN;
	public static final int ISO_IN=Usb4allAPIWrapper.ISO_IN;
	
	//enum USBTransOUT {NULL_OUT = 5,BULK_OUT,CTRL_OUT,INT_OUT,ISO_OUT};
	public static final int NULL_OUT=Usb4allAPIWrapper.NULL_OUT;
	public static final int BULK_OUT=Usb4allAPIWrapper.BULK_OUT;
	public static final int CTRL_OUT=Usb4allAPIWrapper.CTRL_OUT;
	public static final int INT_OUT=Usb4allAPIWrapper.INT_OUT;
	public static final int ISO_OUT=Usb4allAPIWrapper.ISO_OUT;
	
	
	//TODO investigar enum 
	protected int state=BOARD_UNASSIGNED;
	
	protected Usb4allDevice(int usbin, int usbout){
		this.usbin=usbin;
		this.usbout=usbout;
	}
	
	protected final int send(byte[] data) throws Usb4allException
	{
		if (state!=INITIALIZED) throw new Usb4allDeviceNotInitializedException();
		int ret=0xFF;
		try {
			ret = Usb4allAPIWrapper.sendData(handler,data, data.length);
		} catch (NativeException e) {
			throw new Usb4allDllException();
		} catch (IllegalAccessException e) {
			//TODO Auto-generated catch block
			e.printStackTrace();
		}
		return ret;  
	}
	protected final void open() throws Usb4allException{
		int ret=0xFF;
		try {
			ret = Usb4allAPIWrapper.openDevice(board.getIdBoard(),moduleName, usbin, usbout);
		} catch (NativeException e) {
			throw new Usb4allDllException();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (ret!=0xFF){
			handler = ret;
		}
		else {
			throw new Usb4allOpenError();
		}
	}
	
	protected final byte[] receive(int length) throws Usb4allException {
		if (state!=INITIALIZED) throw new Usb4allDeviceNotInitializedException();
		//TODO reveer el campo length
		ReadBytes rb = null;
			try {
				rb = Usb4allAPIWrapper.receiveData(handler,length);
			} catch (NativeException e) {
				throw new Usb4allDllException();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return rb.getReadBytes();
	}

	public final void release() throws Usb4allException{
		switch(state){
		case BOARD_UNASSIGNED:
			throw new Usb4allReleaseException();
			//break;
		case BOARD_ASSIGNED:
			throw new Usb4allReleaseException();
			//break;
		case INITIALIZED:
			int ret=0xFF;
			try {
				ret = Usb4allAPIWrapper.closeDevice(handler);
			} catch (NativeException e) {
				throw new Usb4allDllException();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			if (ret==0xFF){
				throw new Usb4allCloseException();
			}
			else{
				state = RELEASED;
				board.releaseDevice(this);
				board=null;
			}
			break;
		case RELEASED:
			throw new Usb4allAlreadyReleasedException();
			//break;
		}
		
		
	}
	
	public final void init() throws Usb4allException {
		switch(state){
		case BOARD_UNASSIGNED:
			throw new Usb4allInitException();
			//break;
		case BOARD_ASSIGNED:
			open(); //si da excepcion el open, entonces no se cambia de estado.
			state=INITIALIZED;
			break;
		case INITIALIZED:
			throw new Usb4allAlreadyInitializedException();
			//break;
		case RELEASED:
			open(); //si da excepcion el open, entonces no se cambia de estado.
			state=INITIALIZED;
			break;
		}
	}
	
	public final void setBoard(Usb4allBoard b) throws Usb4allException{
		switch(state){
			case BOARD_UNASSIGNED:
				board = b;
				state=BOARD_ASSIGNED;
				b.addDevice(this);
				break;
			case BOARD_ASSIGNED:
				throw new Usb4allBoardAlreadyAssignedException();
				//break;
			case INITIALIZED:
				throw new Usb4allAlreadyInitializedException();
				//break;
			case RELEASED:
				board = b;
				state=BOARD_ASSIGNED;
				b.addDevice(this);
				break;
		}
	}
}
